% -------------------------
%  Problem isporuke goriva
%        (LP metoda)
% -------------------------

clear

%% Ucitavanje podataka iz EXCEL-a
f=xlsread('Data2.xlsx','B3:S3'); % F-ja troskova

Aeq=xlsread('Data2.xlsx','B7:S18'); % Aeq (matrica ogranicenja)
Beq=xlsread('Data2.xlsx','U7:U18'); % Beq (vektor ogranicenja)

Lb=xlsread('Data2.xlsx','B22:S22')'; % Lb (Donja granica)
Ub=xlsread('Data2.xlsx','B23:S23')'; % Lb (Donja granica)

V1start=xlsread('Data2.xlsx','W13:W13')'; % Pocetni nivo uglja
V2start=xlsread('Data2.xlsx','W14:W14');

Ppot=xlsread('Data2.xlsx','U7:U9')'; % Potrosnja

%% LP optimizaciona metoda
A=[]; b=[]; % Nema ogranicenja tipa nejednakosti

[X,fval,exitflag] = linprog(f,A,b,Aeq,Beq,Lb,Ub); % Resavanje LP problema

KritFun = 3*83269.2 + 3*127814.4 + fval; % Vrednost kriterijumske funkcije

P1=X(1:3); % Proizvodnja TE
P2=X(4:6);
D1=X(7:9); % Isporuke uglja
D2=X(10:12);
V1=X(13:15); % Kolicine uglja
V2=X(16:18);
V1=[V1start; V1];
V2=[V2start; V2];

%% Upis rezultata u EXCEL fajl

Time=clock;
Year=num2str(Time(1));
Month=num2str(Time(2));
Day=num2str(Time(3));
Hour=num2str(Time(4));
Minute=num2str(Time(5));
FileName=['Results' '_' Year '_' Month '_' Day '_' Hour '_' Minute '.xlsx'];

Text1=[{'Sedmica'} {'P1 [MW]'} {'D1 [t]'} {'V1 [t]'} {'P2 [MW]'} {'D2 [t]'} {'V2 [t]'}];
Text2=[{'1'}; {'2'}; {'3'}; {'4'}];
Text3=[{'KrFun [$]'}];
Text4=[{'$'}];
xlswrite(FileName, Text1, 'Sheet1','A1:G1');
xlswrite(FileName, Text2, 'Sheet1','A2:A5');
xlswrite(FileName, P1, 'Sheet1','B2:B4');
xlswrite(FileName, D1, 'Sheet1','C2:C4');
xlswrite(FileName, V1, 'Sheet1','D2:D5');
xlswrite(FileName, P2, 'Sheet1','E2:E4');
xlswrite(FileName, D2, 'Sheet1','F2:F4');
xlswrite(FileName, V2, 'Sheet1','G2:G5');

xlswrite(FileName, Text3, 'Sheet1','A7:A7');
xlswrite(FileName, KritFun, 'Sheet1','B7:B7');

%% Crtanje grafika pojedinih velicina

% Crtanje grafika potrosnje
subplot(2,2,1)
bar(Ppot,'b')
title('Potrosnja','FontSize', 20);
xlabel('Sedmica','FontSize', 20);
ylabel('P [MW]','FontSize', 20);
set(gca,'FontSize',20)
axis([0.5 3.5 0 1.1*max(Ppot)])
grid

% Crtanje grafika proizvodnje TE
subplot(2,2,2)
bar([P1 P2],'grouped')
colormap([1 0 0; 0 1 0]);
title('Proizvodnja TE','FontSize', 20);
xlabel('Sedmica','FontSize', 20);
ylabel('P [MW]','FontSize', 20);
set(gca,'FontSize',20)
axis([0.5 3.5 0 1.1*max(max(P1),max(P2))])
legend('TE1','TE2')
grid

% Crtanje grafika isporuke uglja
subplot(2,2,3)
bar([D1 D2],'grouped')
colormap([1 0 0; 0 1 0]);
title('Isporuka uglja','FontSize', 20);
xlabel('Sedmica','FontSize', 20);
ylabel('D [t]','FontSize', 20);
set(gca,'FontSize',20)
axis([0.5 3.5 0 1.1*max(max(D1),max(D2))])
legend('TE1','TE2')
grid

% Crtanje grafika kolicine uglja
subplot(2,2,4)
bar([V1 V2],'grouped')
colormap([1 0 0; 0 1 0]);
title('Kolicina uglja','FontSize', 20);
xlabel('Sedmica','FontSize', 20);
ylabel('V [t]','FontSize', 20);
set(gca,'FontSize',20)
axis([0.5 4.5 0 1.1*max(max(V1),max(V2))])
legend('TE1','TE2')
grid

